<?php

// Includes
include( get_template_directory() . '/includes/setup.php' );
include( get_template_directory() . '/includes/widgets.php' );
include( get_template_directory() . '/includes/template-tags.php' );
include( get_template_directory() . '/includes/front/enqueue.php' );

include( get_template_directory() . '/includes/theme-customizer.php' );
include( get_template_directory() . '/includes/customizer/sanitize.php' );
include( get_template_directory() . '/includes/customizer/default.php' );
include( get_template_directory() . '/includes/customizer/layout.php' );
include( get_template_directory() . '/includes/customizer/misc.php' );
include( get_template_directory() . '/includes/customizer/social.php' );

// Hooks
add_action( 'after_setup_theme', 'thesimplest_theme_setup' );
add_action( 'widgets_init', 'thesimplest_widgets_init' );
add_action( 'wp_enqueue_scripts', 'thesimplest_theme_enqueue' );
add_action( 'customize_register', 'thesimplest_customize_register' );
function wps_deregister_styles() {
    wp_dequeue_style( 'wp-block-library' );
}
add_action( 'wp_print_styles', 'wps_deregister_styles', 100 );


//Remove P Tag and Br Tag



remove_filter( 'the_content', 'wpautop' );

remove_filter( 'the_excerpt', 'wpautop' );



//Remove Emoji
remove_action( 'wp_head', 'print_emoji_detection_script', 7 );
remove_action( 'wp_print_styles', 'print_emoji_styles' );
remove_action( 'wp_head', 'rest_output_link_wp_head', 10 );
remove_action( 'wp_head', 'wp_oembed_add_discovery_links', 10 );
//Remove Shortlink
remove_action('wp_head', 'wp_shortlink_wp_head');
remove_action( 'wp_head', 'wp_resource_hints', 2 );
//Remove Wordpress Generator
remove_action('wp_head', 'wp_generator');
//Remove RSD Link
remove_action ('wp_head', 'rsd_link');
//Remove Manifest Link
remove_action( 'wp_head', 'wlwmanifest_link');
//Remove 

add_action( 'widgets_init', 'my_remove_recent_comments_style' );
function my_remove_recent_comments_style() {
	global $wp_widget_factory;
	remove_action( 'wp_head', array( $wp_widget_factory->widgets['WP_Widget_Recent_Comments'], 'recent_comments_style'  ) );
}

function remove_posts_menu() {

    remove_menu_page('edit.php');

    remove_menu_page( 'edit-comments.php' );

}

add_action('admin_init', 'remove_posts_menu');



// Prevent to Removing <Span> tag from Page Editor



function override_mce_options($initArray) {

$opts = '*[*]';

$initArray['valid_elements'] = $opts;

$initArray['extended_valid_elements'] = $opts;

return $initArray;} add_filter('tiny_mce_before_init', 'override_mce_options');

//Remove Yoast SEO Comment

if (defined('WPSEO_VERSION')){
  add_action('get_header',function (){ ob_start(function ($o){
  return preg_replace('/\n?<.*?yoast.*?>/mi','',$o); }); });
  add_action('wp_head',function (){ ob_end_flush(); }, 999);
}
//Execute PHP Code in Widget
function php_execute($html){
if(strpos($html,"<"."?php")!==false){ ob_start(); eval("?".">".$html);
$html=ob_get_contents();
ob_end_clean();
}
return $html;
}
add_filter('widget_text','php_execute',100);

//Change  logo of login Screen
function my_login_logo_one() { 
?> 
<style type="text/css"> 
body.login div#login h1 a {
background-image: url(/wp-content/themes/go4digitals/img/logo.png);  //Add your own logo image in this url 
padding-bottom: 30px; 
background-size: 220px;
width:100%

} 
</style>
<?php 
} add_action( 'login_enqueue_scripts', 'my_login_logo_one' );
function my_login_logo_url() {
    return home_url();
}
add_filter( 'login_headerurl', 'my_login_logo_url' );

function my_login_logo_url_title() {
    return 'GO4Digital Solutions';
}
add_filter( 'login_headertitle', 'my_login_logo_url_title' );
/**

 * Function for My Custom Header Menu by Shashi Bhushan Sinha .

 */
// Remove List Item Id and WP class from Menu 

add_filter('nav_menu_item_id', 'filter_menu_id');
add_filter( 'nav_menu_css_class', 'filter_menu_li' );
function filter_menu_li(){
    return array('');   
}
function filter_menu_id(){
    return; 
}

function annointed_admin_bar_remove() {
        global $wp_admin_bar;

        /* Remove their stuff */
        $wp_admin_bar->remove_menu('wp-logo');
}
add_action('wp_before_admin_bar_render', 'annointed_admin_bar_remove', 0);
/*Function for admin footer credit start */
function wpse_edit_footer() {
    add_filter( 'admin_footer_text', 'wpse_edit_text', 11 );
}
function wpse_edit_text($content) {
    return "Proudly Powered By GO4Digital Solution";
}
add_action( 'admin_init', 'wpse_edit_footer' );
/*Function for admin footer credit End */


//Function for removing Post from New Section Top Admin Bar
function remove_admin_bar_links() {
        global $wp_admin_bar;
        $wp_admin_bar->remove_menu('new-post');
    }
    add_action( 'wp_before_admin_bar_render', 'remove_admin_bar_links' );

// Remove Sub-menu class to Own CSS Class

function new_submenu_class($menu) {    
    $menu = preg_replace('/ class="sub-menu"/',' class="dropdown-menu"',$menu);        
    return $menu;      
}
add_filter('wp_nav_menu','new_submenu_class'); 


// Remove WP Version From Styles	
add_filter( 'style_loader_src', 'sdt_remove_ver_css_js', 9999 );
// Remove WP Version From Scripts
add_filter( 'script_loader_src', 'sdt_remove_ver_css_js', 9999 );

// Function to remove version numbers
function sdt_remove_ver_css_js( $src ) {
	if ( strpos( $src, 'ver=' ) )
		$src = remove_query_arg( 'ver', $src );
	return $src;
}

add_filter( 'wpseo_json_ld_output', '__return_empty_array' );

remove_action( 'wp_head', 'feed_links_extra', 3 ); // Display the links to the extra feeds such as category feeds
remove_action( 'wp_head', 'feed_links', 2 ); // Display the links to the general feeds: Post and Comment Feed
remove_action( 'wp_head', 'rsd_link' ); // Display the link to the Really Simple Discovery service endpoint, EditURI link
remove_action( 'wp_head', 'wlwmanifest_link' ); // Display the link to the Windows Live Writer manifest file.
remove_action( 'wp_head', 'index_rel_link' ); // index link
remove_action( 'wp_head', 'parent_post_rel_link', 10, 0 ); // prev link
remove_action( 'wp_head', 'start_post_rel_link', 10, 0 ); // start link
remove_action( 'wp_head', 'adjacent_posts_rel_link', 10, 0 ); // Display relational links for the posts adjacent to the current post.
remove_action( 'wp_head', 'wp_generator' ); // Display the XHTML generator that is generated on the wp_head hook, WP version
add_filter( 'style_loader_tag', 'html5_style_tag' );

function html5_style_tag( $tag ) {
    return preg_replace( '~\s+media=["\'][^"\']++["\']~i', '', $tag );
}

function wordpress_breadcrumbs() {
$delimiter = '';
$name = 'Home'; //text for the 'Home' link
$currentBefore = '<li>';
$currentAfter = '</li>';
if ( !is_home() && !is_front_page() || is_paged() ) {
echo '<ol class="breadcrumb">';
global $post;
$home = get_bloginfo('url');
echo '<li><a href="' . $home . '">' . $name . '</a> ' . $delimiter . '</li>';
if ( is_category() ) {
global $wp_query;
$cat_obj = $wp_query->get_queried_object();
$thisCat = $cat_obj->term_id;
$thisCat = get_category($thisCat);
$parentCat = get_category($thisCat->parent);
if ($thisCat->parent != 0) echo(get_category_parents($parentCat, TRUE, ' ' . $delimiter . ' '));
echo $currentBefore . 'Archive by category &#39;';
single_cat_title();
echo '&#39;' . $currentAfter;
} elseif ( is_day() ) {
echo '<a href="' . get_year_link(get_the_time('Y')) . '">' . get_the_time('Y') . '</a> ' . $delimiter . ' ';
echo '<a href="' . get_month_link(get_the_time('Y'),get_the_time('m')) . '">' . get_the_time('F') . '</a> ' . $delimiter . ' ';
echo $currentBefore . get_the_time('d') . $currentAfter;
} elseif ( is_month() ) {
echo '<a href="' . get_year_link(get_the_time('Y')) . '">' . get_the_time('Y') . '</a> ' . $delimiter . ' ';
echo $currentBefore . get_the_time('F') . $currentAfter;
} elseif ( is_year() ) {
echo $currentBefore . get_the_time('Y') . $currentAfter;
} elseif ( is_single() ) {
$cat = get_the_category(); $cat = $cat[0];
echo get_category_parents($cat, TRUE, ' ' . $delimiter . ' ');
echo $currentBefore;
the_title();
echo $currentAfter;
} elseif ( is_page() && !$post->post_parent ) {
echo $currentBefore;
the_title();
echo $currentAfter;
} elseif ( is_page() && $post->post_parent ) {
$parent_id = $post->post_parent;
$breadcrumbs = array();
while ($parent_id) {
$page = get_page($parent_id);
$breadcrumbs[] = '<li><a href="' . get_permalink($page->ID) . '">' . get_the_title($page->ID) . '</a></li>';
$parent_id = $page->post_parent;
}
$breadcrumbs = array_reverse($breadcrumbs);
foreach ($breadcrumbs as $crumb) echo $crumb . ' ' . $delimiter . ' ';
echo $currentBefore;
the_title();
echo $currentAfter;
} elseif ( is_search() ) {
echo $currentBefore . 'Search results for &#39;' . get_search_query() . '&#39;' . $currentAfter;
} elseif ( is_tag() ) {
echo $currentBefore . 'Posts tagged &#39;';
single_tag_title();
echo '&#39;' . $currentAfter;
} elseif ( is_author() ) {
global $author;
$userdata = get_userdata($author);
echo $currentBefore . 'Articles posted by ' . $userdata->display_name . $currentAfter;
} elseif ( is_404() ) {
echo $currentBefore . 'Error 404' . $currentAfter;
}
if ( get_query_var('paged') ) {
if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ) echo ' (';
echo __('Page') . ' ' . get_query_var('paged');
if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ) echo ')';
}
echo '</ol>';
}
}
function register_foundation_style() {
  if ( is_page_template( 'template-appform.php' ) ) {
	  wp_enqueue_style( 'bootstrap-min', get_stylesheet_directory_uri() . '/assets/css/bootstrap.min.css' );
	  wp_enqueue_style( 'bootstrap-grid', get_stylesheet_directory_uri() . '/assets/css/bootstrap-grid.min.css' );
	  wp_enqueue_style( 'Form', get_stylesheet_directory_uri() . '/assets/css/form.css' );
	  wp_dequeue_style( 'tmm' );
	  wp_dequeue_style( 'menu-icons-extra' );
	  wp_enqueue_script( 'bootstrap-min', 'https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/js/bootstrap.min.js');
	   	  
  }
}
add_action( 'wp_enqueue_scripts', 'register_foundation_style',999 );
